<?php
/* --------------------------------------------------------------
   DeletionOfMultipleTrackingCodesRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeIds;

/**
 * Class DeletionOfMultipleTrackingCodesRequested
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class DeletionOfMultipleTrackingCodesRequested
{
    /**
     * @var TrackingCodeIds
     */
    private $trackingCodeIds;
    
    
    /**
     * DeletionOfMultipleTrackingCodesRequested constructor.
     *
     * @param TrackingCodeIds $trackingCodeIds
     */
    private function __construct(TrackingCodeIds $trackingCodeIds)
    {
        $this->trackingCodeIds = $trackingCodeIds;
    }
    
    
    /**
     * @param TrackingCodeIds $trackingCodeIds
     *
     * @return DeletionOfMultipleTrackingCodesRequested
     */
    public static function create(TrackingCodeIds $trackingCodeIds): DeletionOfMultipleTrackingCodesRequested
    {
        return new self($trackingCodeIds);
    }
    
    
    /**
     * @return TrackingCodeIds
     */
    public function trackingCodeIds(): TrackingCodeIds
    {
        return $this->trackingCodeIds;
    }
    
    
    /**
     * @param TrackingCodeIds $trackingCodeIds
     */
    public function replaceTrackingCodes(TrackingCodeIds $trackingCodeIds): void
    {
        $this->trackingCodeIds = $trackingCodeIds;
    }
}